/*
 * Decompiled with CFR 0.152.
 */
package mochi;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import mochi.MochiApp;
import mochi.UsaKaeshiTe;
import mochi.UsaTsukiTe;
import mochi.newscore;
import mochi.sccanvas;

class GameCanvas
extends Canvas
implements Runnable,
CommandListener {
    private static final short TITLE = 0;
    private static final short GAME_START = 1;
    private static final short GAME_PLAYING = 2;
    private static final short GAME_END = 3;
    private static final short GAME_ERROR = 4;
    private static final long DRAW_INTERVAL = 2L;
    private static final int U_NEUTRAL = 3;
    private static final int U_WAIT = 2;
    private static final int U_READY = 1;
    private static final int U_HIT = 0;
    private static final int[] imgKLeft = new int[]{14, 4, 67, 4};
    private static final int[] imgKTop = new int[]{54, 66, 53, 66};
    private static final int[] imgTLeft = new int[]{99, 159, 155, 155};
    private static final int[] imgTTop = new int[]{33, 0, 52, 52};
    private short gameState;
    private boolean isPaused;
    private int screenWidth;
    private int screenHeight;
    private MochiApp mochiApp;
    private Image titleImg;
    private int tState;
    private int kState;
    private boolean isStopped;
    private boolean isKeyEnable;
    private Font defFont = Font.getDefaultFont();
    private Image offImg;
    private Image usaKImg;
    private Image usaTImg;
    private Image bakeKImg;
    private Image bakeTImg;
    private Image usuImg;
    private Image[] usaTImgStat = new Image[4];
    private Image[] usaKImgStat = new Image[4];
    private String errStr = null;
    private long score = 0L;
    private long hiscore = 0L;
    private static int MinHighScore = 0;
    static int NHighScores = 9;
    private Command rankCmd = new Command("\uff97\uff9d\uff77\uff9d\uff78\uff9e", 1, 1);
    private Command exitCmd = new Command("\u9589\u3058\u308b", 1, 1);
    private Command pauseCmd = new Command("\u4e2d\u65ad", 1, 5);
    private Command resumeCmd = new Command("\u518d\u958b", 1, 5);
    private Command quitCmd = new Command("\u7d42\u4e86", 1, 1);
    public UsaTsukiTe usaT;
    public UsaKaeshiTe usaK;

    GameCanvas(MochiApp mochiApp) {
        this.mochiApp = mochiApp;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.offImg = Image.createImage((int)this.screenWidth, (int)this.screenHeight);
        this.setCommandListener(this);
        try {
            this.titleImg = Image.createImage((String)"/res/title.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.InitHighScores();
        this.gameState = 0;
    }

    private void InitHighScores() {
        this.hiscore = -1L;
        MinHighScore = -1;
        RecordStore rs = null;
        RecordEnumeration re = null;
        byte[] w = null;
        try {
            rs = RecordStore.openRecordStore((String)"HiScores", (boolean)true);
            int n = 0;
            if (rs.getNumRecords() > 0) {
                re = rs.enumerateRecords(null, null, true);
                while (re.hasNextElement()) {
                    int pos;
                    w = re.nextRecord();
                    String sData = new String(w);
                    int Sc = Integer.parseInt(sData.substring(0, pos = sData.indexOf(",")));
                    if ((long)Sc > this.hiscore) {
                        this.hiscore = Sc;
                    }
                    if (Sc < MinHighScore || MinHighScore < 0) {
                        MinHighScore = Sc;
                    }
                    if (++n <= NHighScores - 1) continue;
                }
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    static boolean GotHighScore(long score) {
        return score > (long)MinHighScore;
    }

    private void doGameInit() {
        this.isStopped = false;
        this.isKeyEnable = true;
        this.usaT = new UsaTsukiTe(this);
        this.usaK = new UsaKaeshiTe(this);
        try {
            this.usuImg = Image.createImage((String)"/res/usu.png");
            this.usaKImg = Image.createImage((String)"/res/usaK.png");
            this.usaTImg = Image.createImage((String)"/res/usaT.png");
            this.bakeKImg = Image.createImage((String)"/res/bakeK.png");
            this.bakeTImg = Image.createImage((String)"/res/bakeT.png");
            for (int n = 0; n < 3; ++n) {
                this.usaKImgStat[n] = Image.createImage((String)("/res/usaK" + Integer.toString(n) + ".png"));
                this.usaTImgStat[n] = Image.createImage((String)("/res/usaT" + Integer.toString(n) + ".png"));
            }
            this.usaKImgStat[3] = Image.createImage((String)"/res/usaK1.png");
            this.usaTImgStat[3] = Image.createImage((String)"/res/usaT2.png");
        }
        catch (Exception e) {
            this.errStr = e.getMessage();
            this.gameState = (short)4;
            this.repaint();
        }
    }

    private void doThreadStart() {
        new Thread(this).start();
    }

    public void run() {
        try {
            switch (this.gameState) {
                case 4: {
                    this.repaint();
                    break;
                }
                case 1: {
                    this.removeCommand(this.exitCmd);
                    this.removeCommand(this.rankCmd);
                    this.repaint();
                    Thread.sleep(1500L);
                    this.addCommand(this.quitCmd);
                    if (!this.isPaused) {
                        this.addCommand(this.pauseCmd);
                    }
                    this.gameState = (short)2;
                }
                case 2: {
                    this.repaint();
                    boolean isGameOver = false;
                    while (!this.isStopped) {
                        this.usaT.Tick();
                        this.usaK.Tick();
                        this.repaint();
                        if (this.usaT.status() == 0) {
                            switch (this.usaK.status()) {
                                case 0: 
                                case 2: {
                                    isGameOver = true;
                                    this.isStopped = true;
                                }
                            }
                        }
                        Thread.sleep(2L);
                    }
                    if (!isGameOver) break;
                    this.removeCommand(this.pauseCmd);
                    this.removeCommand(this.resumeCmd);
                    this.removeCommand(this.quitCmd);
                    this.repaint();
                    Thread.sleep(1000L);
                    if (GameCanvas.GotHighScore(this.score)) {
                        long HiScore = this.score;
                        Display.getDisplay((MIDlet)MochiApp.midlet).setCurrent((Displayable)new newscore(HiScore));
                    }
                    this.gameState = (short)3;
                    this.repaint();
                    Thread.sleep(2000L);
                    this.doTitle();
                }
            }
        }
        catch (Exception e) {
            this.errStr = e.getMessage();
            this.gameState = (short)4;
            this.repaint();
        }
    }

    public void doStartApp() {
        switch (this.gameState) {
            case 0: {
                this.doTitle();
                break;
            }
            case 1: 
            case 2: {
                this.isPaused = true;
                this.isStopped = true;
                this.removeCommand(this.pauseCmd);
                this.removeCommand(this.resumeCmd);
                this.addCommand(this.resumeCmd);
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.isPaused = false;
            }
        }
    }

    public void doPauseApp() {
        switch (this.gameState) {
            case 0: {
                break;
            }
            default: {
                this.isPaused = true;
                this.isStopped = true;
            }
        }
    }

    private void doPauseOrResume() {
        if (this.isPaused) {
            this.isPaused = false;
            this.isStopped = false;
            this.doThreadStart();
        } else {
            this.isPaused = true;
            this.doGameStop();
        }
        this.repaint();
    }

    private void doTitle() {
        this.gameState = 0;
        this.removeCommand(this.pauseCmd);
        this.removeCommand(this.resumeCmd);
        this.removeCommand(this.quitCmd);
        this.repaint();
        this.addCommand(this.exitCmd);
        this.addCommand(this.rankCmd);
    }

    private void doGameStop() {
        this.isStopped = true;
    }

    private void StartGame() {
        this.doGameInit();
        this.gameState = 1;
        this.doThreadStart();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.rankCmd) {
            Display.getDisplay((MIDlet)MochiApp.midlet).setCurrent((Displayable)new sccanvas(-1));
        } else if (command == this.exitCmd) {
            this.mochiApp.doExit();
        } else if (command == this.pauseCmd) {
            this.removeCommand(this.pauseCmd);
            this.addCommand(this.resumeCmd);
            this.doPauseOrResume();
        } else if (command == this.resumeCmd) {
            this.removeCommand(this.resumeCmd);
            this.addCommand(this.pauseCmd);
            this.doPauseOrResume();
        } else if (command == this.quitCmd) {
            this.doGameStop();
            this.removeCommand(this.pauseCmd);
            this.removeCommand(this.resumeCmd);
            this.removeCommand(this.quitCmd);
            this.doTitle();
        }
    }

    private void drawScore(Graphics g, int y0) {
        g.setColor(0);
        String scStr = "    " + Long.toString(this.score);
        String hiscStr = "    " + Long.toString(this.hiscore);
        String scoreStr = "\u30b9\u30b3\u30a2\u3000\u3000\uff1a" + scStr.substring(scStr.length() - 5);
        int x = (this.screenWidth - this.defFont.stringWidth(scoreStr)) / 2;
        g.drawString(scoreStr, x, y0, 4 | 0x10);
        String hiscoreStr = "\u30cf\u30a4\u30b9\u30b3\u30a2\uff1a" + hiscStr.substring(hiscStr.length() - 5);
        x = (this.screenWidth - this.defFont.stringWidth(hiscoreStr)) / 2;
        g.drawString(hiscoreStr, x, y0 + this.defFont.getHeight(), 4 | 0x10);
    }

    protected void paint(Graphics graphics) {
        Graphics g = this.offImg.getGraphics();
        g.setFont(this.defFont);
        switch (this.gameState) {
            case 0: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.screenWidth, this.screenHeight);
                g.setColor(0);
                g.drawImage(this.titleImg, 0, 0, 4 | 0x10);
                String titleStr = "\u3046\u3055\u7530\u3055\u3093\u306e\u3082\u3061\u3064\u304d";
                int x = (this.screenWidth - this.defFont.stringWidth(titleStr)) / 2;
                int y = this.screenHeight / 2 + this.defFont.getHeight() * 2;
                g.drawString(titleStr, x, y, 4 | 0x10);
                g.setColor(255);
                String startStr = "HIT ANY KEY !";
                x = (this.screenWidth - this.defFont.stringWidth(startStr)) / 2;
                y = this.screenHeight / 2 + this.defFont.getHeight() * 4;
                g.drawString(startStr, x, y, 4 | 0x10);
                this.drawScore(g, this.screenHeight / 2 + this.defFont.getHeight() * 6);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int col = 0;
                if (this.usaT.speed() < 8) {
                    col = 4352 * (8 - this.usaT.speed());
                }
                g.setColor(0xFFFF99 - col);
                g.fillRect(0, 0, this.screenWidth, this.screenHeight);
                g.drawImage(this.usuImg, 82, 52, 4 | 0x10);
                g.drawImage(this.usaTImg, 143, 2, 4 | 0x10);
                g.drawImage(this.usaKImg, 11, 9, 4 | 0x10);
                g.drawImage(this.bakeKImg, 1, 91, 4 | 0x10);
                g.drawImage(this.bakeTImg, 191, 84, 4 | 0x10);
                g.drawImage(this.usaKImgStat[this.usaK.status()], imgKLeft[this.usaK.status()], imgKTop[this.usaK.status()], 4 | 0x10);
                g.drawImage(this.usaTImgStat[this.usaT.status()], imgTLeft[this.usaT.status()], imgTTop[this.usaT.status()], 4 | 0x10);
                g.setColor(0);
                switch (this.gameState) {
                    case 2: 
                    case 3: {
                        this.score = this.usaK.score();
                        if (this.score > this.hiscore) {
                            this.hiscore = this.score;
                        }
                        int y = this.screenHeight / 2;
                        this.drawScore(g, y);
                        break;
                    }
                    case 1: {
                        String msgStr = "\u30b2\u30fc\u30e0\u958b\u59cb";
                        int x = (this.screenWidth - this.defFont.stringWidth(msgStr)) / 2;
                        int y = this.screenHeight / 2;
                        g.drawString(msgStr, x, y, 4 | 0x10);
                        g.setColor(0x666666);
                        g.drawString("[MENU]/[5] -- \u6c34\u3092\u3064\u3051\u308b(1\u70b9)", 0, y + this.defFont.getHeight() * 3, 4 | 0x10);
                        g.drawString("[ \u2193 ]/[8] -- \u9905\u3092\u8fd4\u3059\u3000(5\u70b9)", 0, y + this.defFont.getHeight() * 4, 4 | 0x10);
                    }
                }
                break;
            }
            case 4: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.screenWidth, this.screenHeight);
                g.setColor(0);
                g.drawString("debug\uff1a" + this.errStr, 0, 0, 4 | 0x10);
            }
        }
        graphics.drawImage(this.offImg, 0, 0, 0x10 | 4);
    }

    protected synchronized void keyPressed(int keyCode) {
        if (this.gameState == 0) {
            this.StartGame();
            return;
        }
        if (!this.isKeyEnable || this.gameState != 2 || this.gameState == 2 && this.isPaused) {
            return;
        }
        if (keyCode == 0) {
            return;
        }
        int gameCode = this.getGameAction(keyCode);
        switch (gameCode) {
            case 8: {
                this.doMizu();
                break;
            }
            case 6: {
                this.doMochi();
            }
        }
    }

    private void doMizu() {
        if (this.usaK.status() == 1) {
            this.usaK.Mizu();
            this.repaint();
            this.serviceRepaints();
        }
    }

    private void doMochi() {
        if (this.usaK.status() == 1) {
            this.usaK.Kaeshi();
            this.repaint();
            this.serviceRepaints();
        }
    }
}

